import { Headphones, Mail, Phone, MapPin, Linkedin, Instagram } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer-lux">
      <div className="container">
        <div className="footer-content-lux">
          <div className="footer-section-lux">
            <div className="footer-logo-lux">
              <div className="footer-logo-icon">
                <Headphones size={20} strokeWidth={2} />
              </div>
              <h2 className="footer-logo-text-lux">AudioLux</h2>
            </div>
            <p className="footer-description-lux">
              Премиальная аренда музыкального оборудования. 
              Эксклюзивные инструменты и техника для профессионалов и ценителей качества.
            </p>
            <div className="footer-social-lux">
              <a href="#" className="social-link-lux">
                <Linkedin size={18} strokeWidth={2} />
              </a>
              <a href="#" className="social-link-lux">
                <Instagram size={18} strokeWidth={2} />
              </a>
            </div>
          </div>
          <div className="footer-section-lux">
            <h3 className="footer-title-lux">Навигация</h3>
            <ul className="footer-links-lux">
              <li><a href="/">Мои аренды</a></li>
              <li><a href="/rent">Арендовать</a></li>
              <li><a href="#">Каталог</a></li>
              <li><a href="#">О нас</a></li>
            </ul>
          </div>
          <div className="footer-section-lux">
            <h3 className="footer-title-lux">Контакты</h3>
            <ul className="footer-links-lux">
              <li>
                <Phone size={16} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} strokeWidth={2} />
                <a href="mailto:info@audiolux.ru">info@audiolux.ru</a>
              </li>
              <li>
                <MapPin size={16} strokeWidth={2} />
                <span>Москва, ул. Премиум, 12</span>
              </li>
            </ul>
          </div>
          <div className="footer-section-lux">
            <h3 className="footer-title-lux">Режим работы</h3>
            <ul className="footer-links-lux">
              <li><span>Пн-Пт: 10:00 - 20:00</span></li>
              <li><span>Сб-Вс: 11:00 - 18:00</span></li>
              <li><span>По предварительной записи</span></li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom-lux">
          <p>&copy; 2025 AudioLux. Премиум качество для профессионалов.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

